#include "devcoons-streaming.h"

	namespace devcoonsStreaming
	{
		int socket_id;

		sockaddr_in network_configuration;

		multimedia_config_t multimedia_configuration;

		socklen_t socket_length;

		pthread_t network_to_video_tid;

		std::queue<cv::Mat> frames;

		pthread_t video_to_frames_tid;

		pthread_t frames_to_network_tid;
		
		std::mutex frames_mutex;
		
		pthread_mutex_t active_mutex;
	
		VideoCapture video;
		
		vector<std::thread> vectorOfThreads;
		
		int thread_step = 0;
	}



	void devcoonsStreaming::StartPlayback()
	{
		pthread_create(&network_to_video_tid, NULL, &NetworkToVideo, NULL);
	}

	int devcoonsStreaming::Initialize(int port)
	{
		socket_length = sizeof(network_configuration) ;

		if ( (socket_id = socket(AF_INET, SOCK_DGRAM, 0)) == -1 )

			return -1;

		memset((char *) &network_configuration, 0, sizeof(network_configuration));

		network_configuration.sin_family = AF_INET;

        	network_configuration.sin_port = htons(port);

	        network_configuration.sin_addr.s_addr = htonl(INADDR_ANY);

		if( bind(socket_id , (struct sockaddr*)&network_configuration, sizeof(network_configuration) ) == -1)

			return -2;

		return 0;
	}

	void devcoonsStreaming::StartStreaming()
	{
		pthread_create(&video_to_frames_tid, NULL, &VideoToFrames, NULL);

		usleep(200000); // wait 2 seconds for buffering;

		pthread_create(&frames_to_network_tid, NULL, &FramesToNetwork, NULL);
	}

	int devcoonsStreaming::Initialize(const char * ip_address, int port, int output_format, int output_width, int output_height, const char * video_source)
	{		
		strcpy(multimedia_configuration.video_source,video_source);
		
		devcoonsStreaming::multimedia_configuration.streaming_format = output_format;
		
		devcoonsStreaming::multimedia_configuration.width = output_width;
		
		devcoonsStreaming::multimedia_configuration.height = output_height;
	
		devcoonsStreaming::network_configuration.sin_port = htons(port);

		if(inet_aton(ip_address, &network_configuration.sin_addr) == 0)

			return -1;

		socket_id = socket(PF_INET, SOCK_DGRAM, 0);

		return 0;
	}
	
	int devcoonsStreaming::BufferElements()
	{
		return frames.size();
	}
	
	int devcoonsStreaming::BufferingThreads()
	{
		return vectorOfThreads.size();
	}
